go
/******************************************************************************************
 *  Procedure Name  :   Verify_Address_AJAX
 *
 *  Scope           :   PUBLIC
 *
 *  Description     :   Wrapper procedure which receives input from Application
 *                      and returns one "verified" String in HTTP format using mod_plsql toolkit
 *                      - Called in an OnChange JavaScript AJAX event in Application
 * AJAX Response String:
 *   ADDRESS1|ADDRESS2|ADDRESS3|ADDRESS4|CITY|STATE|POSTAL|COUNTY|COUNTRY|ADDRESS_ERROR_TEXT
 ******************************************************************************************/
create PROCEDURE [dbo].[Verify_Address_AJAX]
					 @SettingsGroup		nvarchar(50)
                    ,@Address_1			nvarchar(256)
                    ,@Address_2			nvarchar(256) 
                    ,@Address_3			nvarchar(256) 
                    ,@Address_4         nvarchar(256) 
                    ,@City              nvarchar(100) 
                    ,@State             nvarchar(100) 
                    ,@Postal_Code       nvarchar(50) 
                    ,@County_Code       nvarchar(20) 
                    ,@Country_Code      nvarchar(30) 
                    ,@fv_address_type   nvarchar(500) 
                    ,@Company_Name      nvarchar(256) 
                    ,@fv_object_name    nvarchar(500)
                    ,@fv_response		nvarchar(4000) output
as
-- Debug
--Declare @Response nvarchar(4000)
--exec  Verify_Address_AJAX '','10 Fairway Dr Ste 133','','','','Deerfield Beach','FL', '33441','','','','Computer Ways, Inc.','', @Response output
--Select @Response
--Declare	@SettingsGroup nvarchar(50),@Address_1 nvarchar(256),@Address_2 nvarchar(256) ,@Address_3 nvarchar(256) ,@Address_4 nvarchar(256) ,@City nvarchar(100) ,@State nvarchar(100) ,@Postal_Code nvarchar(50) ,@County_Code nvarchar(20) ,@Country_Code nvarchar(30) ,@fv_address_type nvarchar(500) ,@Company_Name nvarchar(256) ,@fv_object_name nvarchar(500) ,@fv_response nvarchar(4000)                 
--select @Address_1 = '', @Address_2 = '10 Fairway Dr Ste 133',@Address_3 = '',@Address_4 = '',@City = 'Deerfield Beach',@State = 'FL',@Postal_Code  = '33441',@County_Code = '',@Country_Code = 'USA',@fv_address_type = 'STANDARD',@Company_Name = 'Computer Ways, Inc.',@fv_object_name = ''
--select @Address_1 = '6530 W Rogers', @Address_2 = '',@Address_3 = '',@Address_4 = '',@City = 'bocaraton',@State = 'FL',@Postal_Code  = '33064',@County_Code = '',@Country_Code = 'USA',@fv_address_type = 'STANDARD',@Company_Name = '',@fv_object_name = ''
--select @Address_1 = '132 Leopold Strasse', @Address_2 = '',@Address_3 = '',@Address_4 = '',@City = 'munich',@State = '',@Postal_Code  = '',@County_Code = '',@Country_Code = 'DEU',@fv_address_type = 'STANDARD',@Company_Name = '',@fv_object_name = ''
--select @Address_1 = '66666530 W Rogers', @Address_2 = '',@Address_3 = '',@Address_4 = '',@City = 'boca raton',@State = 'FL',@Postal_Code  = '33064',@County_Code = '',@Country_Code = 'USA',@fv_address_type = 'STANDARD',@Company_Name = '',@fv_object_name = ''
--select @Address_1 = '6530 W Rogers Ste 31', @Address_2 = '',@Address_3 = '',@Address_4 = '',@City = 'boca raton',@State = 'FL',@Postal_Code  = '33064',@County_Code = '',@Country_Code = 'USA',@fv_address_type = 'STANDARD',@Company_Name = '',@fv_object_name = ''
--End Debug
------------------------------------------------
-- Some global settings
------------------------------------------------
Declare @gn_Max_State_Length int
Set @gn_Max_State_Length = 100
--
Declare @gn_Max_Address_Length int
Set @gn_Max_Address_Length = 256
--
Declare @gn_Max_City_Length int
Set @gn_Max_City_Length = 100
--
Declare @BlankLine nvarchar(2)
set @BlankLine = ' '
-- What about the "l_" variables?
-------------------------------------------------------------------
-- Declare other variables needed to call the main Verify routine.
-------------------------------------------------------------------
Declare
@Address_Name nvarchar(300), /* IN/OUT - Full Name - will be parsed if specified */
@Attention nvarchar(256), /* IN/OUT */
@Address nvarchar(256) ,  /* IN/OUT - House float and Street Address */
@Suite nvarchar(256) ,  /* IN/OUT - Suite / Apartment float */
@Private_Mailbox nvarchar(100) ,  /* Private Mail Box Facility */
@Address_Line_5 nvarchar(256) ,@Address_Line_6 nvarchar(256) ,@Address_Line_7 nvarchar(256) ,@Address_Line_8 nvarchar(256) ,
@City_Abbreviation nvarchar(100) ,
@Postal_Code_Extended nvarchar(50) ,   /* IN/OUT - ie ZIP+4 */
@Last_Line nvarchar(256) ,  /* Last Address Line: City@ State Zip-Plus4 (US Only) , */
@Country_Name nvarchar(100) ,  /* IN/OUT */
@Urbanization nvarchar(256) ,  /* IN/OUT - Puerto Rico Addresses Only */
@Province nvarchar(100) ,  /* IN/OUT - International Addresses */@Carrier_Route nvarchar(20) ,@Delivery_Point_Check_Digit nvarchar(10) ,@Delivery_Point nvarchar(2) ,@Check_Digit nvarchar(1) ,
@Parsed_Address_Range nvarchar(60) ,@Parsed_Address_float nvarchar(60) ,@Parsed_Pre_Direction nvarchar(40) ,@Parsed_Street_Name nvarchar(100) ,@Parsed_Street_Suffix nvarchar(40) ,@Parse_Post_Direction nvarchar(40) ,@Parsed_Unit_Type  nvarchar(40) ,@Parsed_Unit_float  nvarchar(40) ,
@Parsed_Private_Mailbox_Type  nvarchar(40) ,  /* Private Mail Box Type (ie PMB) , */
@Parsed_Private_Mailbox_float nvarchar(40) ,  /* Private Mail Box float (ie 124B) , */
@Suggestion_List nvarchar(4000) ,
@County_Name nvarchar(100) ,@Timezone_Code nvarchar(5) ,@Timezone_String nvarchar(100) ,
@Error_Code nvarchar(20) ,    /* Primary field to check for an address error (View: CLN_ADDRESS_ERRORS_V) , */
@Error_String nvarchar(4000) ,
@Status_Code nvarchar(20) ,    /* Address Status code (View: CLN_ADDRESS_STATUS_V) , */
@DPV_Status nvarchar(20) ,    /* Delivery Point Validation Status - AA BB RR are verified successfully */
@DPV_Error_Code nvarchar(20) ,    /* Decode of DPV_Status and Error_Code to return prominant error code */
@RBDI_Code nvarchar(20) ,    /* (R) ,esidential / (B) ,usiness Delivery Indicator (R/B) , - EXTRA DATA OPTION */
@CMRA nvarchar(1) ,     /* Commercial Mail Receiving Agency (Y/N) , */
@Address_Type_Code nvarchar(20) ,
@Address_Type_String nvarchar(100) ,
@MSA nvarchar(20) ,
@PMSA nvarchar(20) ,
@Congressional_District nvarchar(20) ,
@LACS_Code nvarchar(20) ,    /* L = Address has undergone a conversion */
@Automation_Code nvarchar(20) ,    /* Y = Carrier Route sortation rates apply for this Postal Code */
@Facility_Code nvarchar(20) ,
@Zip_Type_Code nvarchar(20) ,    /* NULL = Standard; P = PO Box Only Postal Code; U = Unique for Organization (ie IRS) ,; M = Military */
@Latitude float(24),@Longitude float(24),@Census_Tract nvarchar(10) ,@Census_Block nvarchar(10) ,
@First_Name nvarchar(100) ,   /* IN/OUT */
@Middle_Name nvarchar(100) ,   /* IN/OUT */
@Last_Name nvarchar(100) ,   /* IN/OUT */
@Name_Prefix nvarchar(50) ,   /* IN/OUT */
@Name_Suffix nvarchar(50) ,   /* IN/OUT */
@Standardized_First_Name nvarchar(100) ,
@Gender nvarchar(50) ,    /* M = Male; F = Female; N = Neutral; U = Unknown */
@First_Name_2 nvarchar(100) ,@Middle_Name_2 nvarchar(100) ,@Last_Name_2 nvarchar(100) ,@Name_Prefix_2 nvarchar(50) ,@Name_Suffix_2 nvarchar(50) ,@Standardized_First_Name_2 nvarchar(100) ,
@Gender_2 nvarchar(50) ,    /* M = Male; F = Female; N = Neutral; U = Unknown */
@Name_Parse_Status_Code nvarchar(20) ,   /* ' ' = Successful Parse; 'V' = Vulgar world found; 'X' = Unable to Parse */
@Phone_float nvarchar(30) ,   /* IN/OUT */
@Phone_float_Output_Format nvarchar(30) ,   /* Format mask to apply for output - Use # for place holder@ ie (###) ,###-#### */
@New_Phone_float nvarchar(30) ,@New_Phone_Area_Code nvarchar(15) ,
@Phone_Area_Code nvarchar(15) ,   /* IN/OUT */
@Phone_Prefix nvarchar(15) ,   /* IN/OUT */
@Phone_Suffix nvarchar(15) ,   /* IN/OUT */
@Phone_Extension nvarchar(15) ,@Phone_Distance float(24),@Phone_Check_Status_Code nvarchar(20) ,@Phone_Check_Error_Code nvarchar(20)
----------------------------------------------------
-- Required so that state does not come back null
----------------------------------------------------
select 
@Province  = '' /* IN/OUT - International Addresses */
------------------------------------------------------------
EXEC Verify 
@SettingsGroup,@Address_Name output,@Company_Name output,@Attention output,
@Address output, @Suite output,@Private_Mailbox output,
@Address_1 output,@Address_2 output,@Address_3 output,@Address_4 output,
@Address_Line_5 output,@Address_Line_6 output,@Address_Line_7 output,@Address_Line_8 output,
@City output,@City_Abbreviation output,@State output,@Postal_Code output,@Postal_Code_Extended output,
@Last_Line output,@Country_Code output,@Country_Name output,@Urbanization output,@Province output,
@Carrier_Route output,@Delivery_Point_Check_Digit output,@Delivery_Point output,@Check_Digit output,
@Parsed_Address_Range output,@Parsed_Address_float output,@Parsed_Pre_Direction output,@Parsed_Street_Name output,@Parsed_Street_Suffix output,@Parse_Post_Direction output,@Parsed_Unit_Type  output,@Parsed_Unit_float  output,@Parsed_Private_Mailbox_Type output,@Parsed_Private_Mailbox_float output,
@Suggestion_List output,
@County_Code output,@County_Name output,
@Timezone_Code output,@Timezone_String output,
@Error_Code output,@Error_String output,@Status_Code output,
@DPV_Status output,@DPV_Error_Code output,
@RBDI_Code output,@CMRA output, @Address_Type_Code output,@Address_Type_String output,
@MSA output,@PMSA output,@Congressional_District output,@LACS_Code output,@Automation_Code output,@Facility_Code output,@Zip_Type_Code output,
@Latitude output,@Longitude output,@Census_Tract output,@Census_Block output,
@First_Name output,@Middle_Name output,@Last_Name output,@Name_Prefix output,@Name_Suffix output,@Standardized_First_Name output,@Gender output,
@First_Name_2 output,@Middle_Name_2 output,@Last_Name_2 output,@Name_Prefix_2 output,@Name_Suffix_2 output,@Standardized_First_Name_2 output,@Gender_2 output,
@Name_Parse_Status_Code output,@Phone_float output,@Phone_float_Output_Format,
@New_Phone_float output,@New_Phone_Area_Code output,@Phone_Area_Code output,@Phone_Prefix output,@Phone_Suffix output,@Phone_Extension output,
@Phone_Distance output,@Phone_Check_Status_Code output,@Phone_Check_Error_Code output
--
-- Clean up fields replacing nulls and blank strings with single spaces to be comaptible with Oracle version
--
set @Address_1 = [dbo].[Clean_Field](@Address_1)
set @Address_2 = [dbo].[Clean_Field](@Address_2)
set @Address_3 = [dbo].[Clean_Field](@Address_3)
set @Address_4 = [dbo].[Clean_Field](@Address_4)
set @City = [dbo].[Clean_Field](@City)
set @State = [dbo].[Clean_Field](@State)
set @Postal_Code = [dbo].[Clean_Field](@Postal_Code)
set @Postal_Code_Extended = [dbo].[Clean_Field](@Postal_Code_Extended)
if @Postal_Code_Extended <> ' ' Set @Postal_Code = @Postal_Code+'-'+@Postal_Code_Extended
set @County_Code = [dbo].[Clean_Field](@County_Code)
set @County_Name = [dbo].[Clean_Field](@County_Name)
set @Country_Code = [dbo].[Clean_Field](@Country_Code)
set @Error_String = [dbo].[Clean_Field](@Error_String)
set @Suggestion_List = [dbo].[Clean_Field](@Suggestion_List)
--
set @Suite = [dbo].[Clean_Field](@Suite)
--
-- Fill in the country name if not present
--
if (@Country_Name is null)
	Select @Country_Name =  [dbo].[Get_Country_Name](@Country_Code)

    -- Add Attention and/or Company back on to address if it was parsed out of address line 3
    -- - Could be stored in company or attention
    -- why different from above?
    -- Test with company or attention or suite and address should keep it all

    if (@Attention <> @BlankLine or @Address_Name <> @BlankLine or @Company_Name <> @BlankLine) and @Address_3 = @BlankLine
	  Begin
		-- make sure Company is not already listed on line 1
		if @Company_Name<> @BlankLine
		  and upper(@Company_Name) <> upper(@Address_1)
		  and upper(@Company_Name) <> upper(@Address_2)
		  and @Address_3 = @BlankLine
		  --and NOT lb_company_input  -- don't append company if it was input separately (Finance)
		  Begin
			set @Address_3 = @Address_2
			set @Address_2 = @Address_1
			set @Address_1 = @Company_Name
			set @Company_Name       = @BlankLine
		  End
      -- make sure Attention is not already listed on line 1
      if @Attention <> @BlankLine
        and upper(@Attention) <> upper(@Address_1)
        and upper(@Attention) <> upper(@Address_2)
        and @Address_3 = @BlankLine
        Begin
			set @Address_3 = @Address_2
			set @Address_2 = @Address_1
			set @Address_1 = @Attention
			set @Attention      = @BlankLine
        End
      -- make sure Address_Name is not already listed on line 1
      if @Address_Name <> @BlankLine
        and upper(@Address_Name) <> upper(@Address_1)
        and upper(@Address_Name) <> upper(@Address_2)
        and @Address_3 = @BlankLine
        Begin
			set @Address_3 = @Address_2
			set @Address_2 = @Address_1
			set @Address_1 = @Address_Name
			set @Address_Name   = @BlankLine
        End
	End
    --
    -- 7/10/09 - account for address_4
    -- Add Attention and/or Company back on to address if it was parsed out of address line 3
    -- - Could be stored in company or attention
    --
    if (@Attention <> @BlankLine or @Address_Name <> @BlankLine or @Company_Name <> @BlankLine) and @Address_4 = @BlankLine
      Begin
		-- make sure Company is not already listed on line 1
		if @Company_Name <> @BlankLine
		  and upper(@Company_Name) <> upper(@Address_1)
		  and upper(@Company_Name) <> upper(@Address_2)
		  and @Address_4 = @BlankLine
		  --and NOT lb_company_input  -- don't append company if it was input separately (Finance)
		  Begin
			set @Address_4 = @Address_3
			set @Address_3 = @Address_2
			set @Address_2 = @Address_1
			set @Address_1 = @Company_Name
			set @Company_Name = @BlankLine
		  End
		-- make sure Attention is not already listed on line 1
		if @Attention <> @BlankLine
		  and upper(@Attention) <> upper(@Address_1)
		  and upper(@Attention) <> upper(@Address_2)
		  and @Address_4 = @BlankLine
		  Begin
			set @Address_4 = @Address_3
			set @Address_3 = @Address_2
			set @Address_2 = @Address_1
			set @Address_1 = @Attention
			set @Attention = @BlankLine
		  End
		-- make sure Address_Name is not already listed on line 1
		if @Address_Name <> @BlankLine
		  and upper(@Address_Name) <> upper(@Address_1)
		  and upper(@Address_Name) <> upper(@Address_2)
		  and @Address_4 = @BlankLine
		  Begin
			set @Address_4 = @Address_3
			set @Address_3 = @Address_2
			set @Address_2 = @Address_1
			set @Address_1 = @Address_Name
			set @Address_Name = @BlankLine
		 End
	End
	--
    -- Fix the last line if present in the returned address line
    -- Don't return line 4 as the city/state/ZIP line (last_line)
    --
    if @Address_4 = @Last_Line
	  Begin
		set @Address_4 = @BlankLine
		-- 7/31/09 check for missing suite issue
		if @Suite <> @BlankLine 
		  and (@Address_1 Not Like '%' + @Suite + '%'
		  or @Address_2 Not Like '%' + @Suite + '%'
		  or @Address_3 NOT LIKE '%' + @Suite + '%')
		  Begin
			set @Address_4 = @Suite
		  End
	  End
	  --
	if @Address_3 = @Last_Line
	  set @Address_3 = @BlankLine
	--
	if @Address_2 = @Last_Line 
	  set @Address_2 = @BlankLine
  
	-- 7/31/09 Fix duplicate Company name issue
	--if NOT lb_company_input
	If  ( @Company_Name = @Address_1
	   or @Company_Name = @Address_2
	   or @Company_Name = @Address_3
	   or @Company_Name = @Address_4
	   ) and @Status_Code NOT like 'AD%' -- 4/28/11 And not an international address - uses Address/Suite below
	  Begin -- Don't need begin end but makes it clearer
		set @Company_Name = @BlankLine
	  End
	  
	-- 3/1/08 - Make sure address data was returned for international verification, otherwise restore original record
	if   (@Address_1 = @BlankLine
	  or @Address_2 = @BlankLine
	  or @Address_3 = @BlankLine
	  or @City = @BlankLine
	  or @State = @BlankLine
	  or @Postal_Code = @BlankLine)
	  Begin -- Will have to make a backup TODO
		-- Restore original input address
		--Set @Company_Name        = l_address_rec_bak.company;
		--Set @Address_1 = l_address_rec_bak.address_1;
		--Set @Address_2 = l_address_rec_bak.address_2;
		--Set @Address_3 = l_address_rec_bak.address_3;
		--Set @Address_4 = l_address_rec_bak.address_4;
		--Set @City           = l_address_rec_bak.City;
		--Set State          = l_address_rec_bak.State;
		--Set @Province       = l_address_rec_bak.Province;
		--Set @Postal_Code    = l_address_rec_bak.postal_code;
		--Set @Country_Code   = l_address_rec_bak.country_code;
		Set @Company_Name = @Company_Name -- just to avoid error from block with no code
	  End
    --
    -- Fix International Addresses where Address 1-4 contains city, province, postal code, country
    --

	if @Status_Code like 'AD%' 
	  Begin
		--
		-- GLOBAL Address
		--
		-- Only use new address if we have a valid city or postal_code
		--
		if @City <> @BlankLine 
		  or @Postal_Code <> @BlankLine
		  Begin
			if @Address <> @BlankLine
			  Begin
				  if @Company_Name <> @BlankLine
					Begin
						Set @Address_1 = @Company_Name
						Set @Address_2 = @Address
						Set @Address_3 = @Suite
						Set @Address_4 = @BlankLine
					End
				  else
					-- 4/28/11 Fix company name appearing after address line
					if @Suite <> @BlankLine
					   -- Move suite to address line 1 if they are already equal
					   -- See if suite does not include a number or # then move to address line 15
					   and dbo.translate(@Suite, '1234567890#', ' ') = @Suite
					   --Select dbo.Translate('#123xxx888','1234567890#',' ') -- Created SQL function equivalent
					   
					  Begin
						Set @Address_1 = @Suite
						Set @Address_2 = @Address
						Set @Address_3 = @BlankLine
						Set @Address_4 = @BlankLine						
					  End
					else
					  Begin
						Set @Address_1 = @Address
						Set @Address_2 = @Suite
						Set @Address_3 = @BlankLine
						Set @Address_4 = @BlankLine						
					  End
				  End -- If company is blank
			  End -- If Address is blank
			--
			-- Get the correct standardized state for international addresses (if available)
			--
			if Len(rtrim(@State) + rtrim(@Province)) > 0
			   and (@Country_Code <> @BlankLine) 
			   --and @Country_Code not in (gv_local_country, 'US', 'USA', 'CA', 'CAN')
			   and @Country_Code not in ('US', 'USA', 'CA', 'CAN')
			  Begin
				-- Need country state table
				--c_state_rec.State = @BlankLine
				--open c_state (@Country_Code, NVL(@State, @Province));
				--fetch c_state
				--into  c_state_rec;
				--if c_state%FOUND then
				--@State = c_state_rec.State;
				--@Province = @BlankLine
			  --close c_state;
				Set @State = @State -- just to avoid error from block with no code
			  End
			--
			-- Append State to City for international addresses if state field is to large and was not found in the STATE table
			-- Declared  @gn_Max_State_Length at begining

			--
			if Len(RTRim(@State) + RTrim(@Province)) > @gn_Max_State_Length
			  Begin
			 --  and c_state_rec.State IS NULL
				if Len(@City + ', ' + RTRim(@State) + RTrim(@Province)) <= @gn_Max_City_Length
				  Begin
					-- try to append state to city field if it will fit
					Set @City = @City + ', ' +  + RTRim(@State) + RTrim(@Province)
					Set @State = @BlankLine
					Set @Province = @BlankLine
				  End
				else if @Address_2 = @BlankLine
				  and Len(RTRim(@State) + RTrim(@Province)) <= @gn_Max_Address_Length
				  and upper(RTrim(@Suite)) <> upper(RTRim(@State) + RTrim(@Province))
				  Begin
					Set @Address_2 = RTRim(@State) + RTrim(@Province)
					Set @State = @BlankLine
					Set @Province = @BlankLine
				  End
				else if @Address_3 = @BlankLine
				  and Len(RTRim(@State) + RTrim(@Province)) <= @gn_Max_Address_Length
				  and upper(RTrim(@Suite)) <> upper(RTRim(@State) + RTrim(@Province))
				  Begin
					Set @Address_3 = RTRim(@State) + RTrim(@Province)
					Set @State = @BlankLine
					Set @Province = @BlankLine
				  End
			  End
			else
			  Begin
				-- default state to NULL if it won't fit any of above fields
				Set @State = @BlankLine
				Set @Province = @BlankLine
			  End
		  End -- If International AD%
      --End 
    --
    -- Look at DPV error code to get description   
	-- Use DPV Status for Error Code if not international
	--
	If  @Status_Code not like 'AD%'
		set @Error_Code = @DPV_Status
    --
	if @Error_String = ''
		Begin
			Set @Error_String = dbo.Help_DPV_Status(@DPV_Status)
			If @Error_String = ''
				set @Error_String = dbo.Get_DPV_Status(@DPV_Status)
		end
		
    -- Set the error string to NULL if there is no error
    if upper(@Error_String) = 'NO ERROR'
      set @Error_String = ''
	
	-- Append the address suggestion list to the end of the error string - limit to 500 characters
	if @Suggestion_List <> @BlankLine 
	  Begin
		Set @Error_String = substring(@Error_String + char(10) + 'Suggestions:' + char(10) + replace(@Suggestion_List,';',char(10)),1,500)
	  End 
		--
		-- get the address status code for the error code for international addresses
		--
    else if @Status_Code like 'AD%'
      BEGIN try

		Set @Error_Code = Replace(@Error_Code,'%','')
		--		--
        -- only use address status if the error code is a number
        -- Odd math, not sure why it made me convert to float before int?? 
        --
        if Isnumeric(@Error_Code) = 1 and cast(cast('100.0' as float) as int) >= 0       
          Begin

			  --
			  -- Check for Valid International Address
			  --
			  if @Status_Code IN ('ADC','ADV') 
				Begin
					set @Error_Code   = ''
					set @Error_String = ''
				End
			  else
				Begin
					set @Error_Code   = @Status_Code
					set @Error_String = dbo.Get_Address_Status(@Status_Code)
				End
		  End
	  End Try
	  Begin Catch
      --EXCEPTION
      --  WHEN OTHERS Begin
      --    @BlankLine
		 
      END Catch;
    else if @Error_Code <> '' 
      Begin
		Set @Error_String = dbo.Get_Address_Error(@Error_Code)
        -- Append the address suggestion list to the end of the error string - limit to 500 characters
        if @Suggestion_List <> @BlankLine Begin
			set @Error_String = substring(@Error_String + char(10) + 'Suggestions:' + char(10) + replace(@Suggestion_List,';',char(10)),1,500)
        End
    End 
    
    Declare @Address_Error_Text nvarchar(500)
    Set @Address_Error_Text = @Error_String
    
    
    if @Address_Error_Text <> '' 
      Begin
		set @Address_Error_Text = replace('Address Warning:<br>' + @Address_Error_Text,char(10),'<br>')
									
		if charindex('Suggestions:',@Address_Error_Text) = 0 
		  Begin
			set @Address_Error_Text = '<b><font color=red>' + @Address_Error_Text + '</font></b>'
		  End
		else
		  Begin
			set @Address_Error_Text = replace('<b><font color=red>' + @Address_Error_Text, 'Suggestions:', '</font><br>Suggestions:</b><br><font color=blue>') + '</font>'
		  End	  
	  End
  -- 
--	
-- Get rid of any spaces
--
Set @Address_1 = rtrim(@Address_1)
Set @Address_2 = rtrim(@Address_2)
Set @Address_3 = rtrim(@Address_3)
Set @Address_4 = rtrim(@Address_4)
Set @City = rtrim(@City)
Set @State = rtrim(@State)
Set @Postal_Code = rtrim(@Postal_Code)
Set @County_Name = rtrim(@County_Name)
Set @Country_Code = rtrim(@Country_Code)
Set @Error_String = rtrim(@Error_String)
Set @Suggestion_List = rtrim(@Suggestion_List)
Set @Address_Error_Text = rtrim(@Address_Error_Text)
--
------------------------------------------------------------------------------------------
-- Return the pipe delimited information for AJAX, one last check for Null string
-- ADDRESS1|ADDRESS2|ADDRESS3|ADDRESS4|CITY|STATE|POSTAL|COUNTY|COUNTRY|ADDRESS_ERROR_TEXT
-------------------------------------------------------------------------------------------
Select @fv_response = 
	  @Address_1 + '|' + @Address_2 + '|' + @Address_3 + '|' + @Address_4 + '|'
	+ @City + '|' + @State + '|' + @Postal_Code + '|' + @County_Name + '|' 
	+ @Country_Code + '|' 
	--+ @Error_String + ' ' + @Suggestion_List + '|' 
	+ @Address_Error_Text +  '|'

-- For testing
--Select @fv_response

Go
